﻿//////////////////////////////////////////////
// RenderCommandQueue.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class RenderCommand ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../../Dll/DllDefines.h"

#include "RenderCommand.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderCommandQueue final
	{
		public :

			// Constructor
			RenderCommandQueue () noexcept ;

			// Getters
			nkMemory::BufferView<RenderCommand> getCommands () const ;

			// Manipulations
			void addCommand (const RenderCommand& command) ;
			void reset () ;

		private :

			// Attributes
			nkMemory::BufferCast<RenderCommand> _commands ;
			unsigned int _commandCounter ;
	} ;
}